/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CeilingBannerBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.items.BlockPlacerItem;
import net.mehvahdjukaar.supplementaries.common.items.FlagItem;
import net.mehvahdjukaar.supplementaries.common.items.OptionalTagBlockItem;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.BuzzierBeesCompat;
import net.mehvahdjukaar.supplementaries.integration.CaveEnhancementsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModCreativeTabs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

public class RegUtils {
    public static void initDynamicRegistry() {
        BlockSetAPI.addDynamicBlockRegistration(RegUtils::registerHangingSignBlocks, WoodType.class);
        BlockSetAPI.addDynamicItemRegistration(RegUtils::registerHangingSignItems, WoodType.class);
        BlockSetAPI.addDynamicItemRegistration(RegUtils::registerSignPostItems, WoodType.class);
    }

    @Nonnull
    public static class_1761 getTab(class_1761 g, String regName) {
        if (CommonConfigs.isEnabled(regName)) {
            return ModCreativeTabs.MOD_TAB == null ? g : ModCreativeTabs.MOD_TAB;
        }
        return null;
    }

    public static class_1761 getTab(String modId, class_1761 g, String regName) {
        return PlatformHelper.isModLoaded((String)modId) ? RegUtils.getTab(g, regName) : null;
    }

    public static Supplier<class_2248> regPlaceableItem(String name, Supplier<? extends class_2248> sup, String itemLocation, Supplier<Boolean> config) {
        Supplier<class_1792> itemSupp = () -> (class_1792)class_2378.field_11142.method_10223(new class_2960(itemLocation));
        return RegUtils.regPlaceableItem(name, sup, itemSupp, config);
    }

    public static Supplier<class_2248> regPlaceableItem(String name, Supplier<? extends class_2248> sup, Supplier<? extends class_1792> itemSupplier, Supplier<Boolean> config) {
        Supplier<class_2248> newSupp = () -> {
            class_2248 b = (class_2248)sup.get();
            BlockPlacerItem.registerPlaceableItem(b, itemSupplier, config);
            return b;
        };
        return RegUtils.regBlock(name, newSupp);
    }

    public static <T extends class_1792> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2591<E>, E extends class_2586> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2248> RegSupplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2248> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, class_1761 tab) {
        return RegUtils.regWithItem(name, blockFactory, new class_1792.class_1793().method_7892(RegUtils.getTab(tab, name)), 0);
    }

    public static <T extends class_2248> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, class_1761 tab, int burnTime) {
        return RegUtils.regWithItem(name, blockFactory, new class_1792.class_1793().method_7892(RegUtils.getTab(tab, name)), burnTime);
    }

    public static <T extends class_2248> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, class_1792.class_1793 properties, int burnTime) {
        RegSupplier<T> block = RegUtils.regBlock(name, blockFactory);
        RegUtils.regBlockItem(name, block, properties, burnTime);
        return block;
    }

    public static <T extends class_2248> Supplier<T> regWithItem(String name, Supplier<T> block, class_1761 tab, String requiredMod) {
        class_1761 t = PlatformHelper.isModLoaded((String)requiredMod) ? tab : null;
        return RegUtils.regWithItem(name, block, t);
    }

    public static RegSupplier<class_1747> regBlockItem(String name, Supplier<? extends class_2248> blockSup, class_1761 group, String tagKey) {
        return RegHelper.registerItem((class_2960)Supplementaries.res(name), () -> new OptionalTagBlockItem((class_2248)blockSup.get(), new class_1792.class_1793().method_7892(group), tagKey));
    }

    public static RegSupplier<class_1747> regBlockItem(String name, Supplier<? extends class_2248> blockSup, class_1792.class_1793 properties, int burnTime) {
        return RegHelper.registerItem((class_2960)Supplementaries.res(name), () -> burnTime == 0 ? new class_1747((class_2248)blockSup.get(), properties) : new WoodBasedBlockItem((class_2248)blockSup.get(), properties, burnTime));
    }

    public static RegSupplier<class_1747> regBlockItem(String name, Supplier<? extends class_2248> blockSup, class_1792.class_1793 properties) {
        return RegUtils.regBlockItem(name, blockSup, properties, 0);
    }

    public static Map<class_1767, Supplier<class_2248>> registerCandleHolders(class_2960 baseName) {
        HashMap<class_1767, Supplier<class_2248>> map = new HashMap<class_1767, Supplier<class_2248>>();
        RegSupplier block = RegHelper.registerBlockWithItem((class_2960)baseName, () -> new CandleHolderBlock(null, class_4970.class_2251.method_9630((class_4970)((class_4970)ModRegistry.SCONCE.get()))), (class_1761)RegUtils.getTab(class_1761.field_7928, "candle_holder"));
        map.put((class_1767)null, (Supplier<class_2248>)block);
        for (class_1767 color : class_1767.values()) {
            String name = baseName.method_12832() + "_" + color.method_7792();
            RegSupplier bb = RegHelper.registerBlockWithItem((class_2960)new class_2960(baseName.method_12836(), name), () -> new CandleHolderBlock(color, class_4970.class_2251.method_9630((class_4970)((class_4970)ModRegistry.SCONCE.get()))), (class_1761)RegUtils.getTab(class_1761.field_7928, "candle_holder"));
            map.put(color, (Supplier<class_2248>)bb);
        }
        if (CompatHandler.BUZZIER_BEES) {
            BuzzierBeesCompat.registerCandle(baseName);
        }
        if (CompatHandler.CAVE_ENHANCEMENTS) {
            CaveEnhancementsCompat.registerCandle(baseName);
        }
        return map;
    }

    public static Map<class_1767, Supplier<class_2248>> registerFlags(String baseName) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (class_1767 color : class_1767.values()) {
            String name = baseName + "_" + color.method_7792();
            RegSupplier<class_2248> block = RegUtils.regBlock(name, () -> new FlagBlock(color, class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)color.method_7794()).method_9632(1.0f).method_22488().method_9626(class_2498.field_11547)));
            builder.put((Object)color, block);
            RegUtils.regItem(name, () -> new FlagItem((class_2248)block.get(), new class_1792.class_1793().method_7889(16).method_7892(RegUtils.getTab(class_1761.field_7928, baseName))));
        }
        return builder.build();
    }

    public static Map<class_1767, Supplier<class_2248>> registerCeilingBanners(String baseName) {
        LinkedHashMap<class_1767, Supplier<class_2248>> map = new LinkedHashMap<class_1767, Supplier<class_2248>>();
        for (class_1767 color : class_1767.values()) {
            String name = baseName + "_" + color.method_7792();
            map.put(color, RegUtils.regPlaceableItem(name, () -> new CeilingBannerBlock(color, class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)color.method_7794()).method_9632(1.0f).method_9634().method_9626(class_2498.field_11547)), color.method_7792() + "_banner", CommonConfigs.Tweaks.CEILING_BANNERS));
        }
        return map;
    }

    public static Map<class_1767, Supplier<class_2248>> registerPresents(String baseName, BiFunction<class_1767, class_4970.class_2251, class_2248> presentFactory) {
        LinkedHashMap<class_1767, Supplier<class_2248>> map = new LinkedHashMap<class_1767, Supplier<class_2248>>();
        RegSupplier<class_2248> block = RegUtils.regBlock(baseName, () -> (class_2248)presentFactory.apply(null, class_4970.class_2251.method_9639((class_3614)class_3614.field_15931, (class_3620)class_3620.field_15996).method_9632(1.0f).method_9626((class_2498)ModSounds.PRESENT)));
        map.put((class_1767)null, (Supplier<class_2248>)block);
        RegUtils.regItem(baseName, () -> new PresentItem((class_2248)block.get(), new class_1792.class_1793().method_7892(RegUtils.getTab(class_1761.field_7928, baseName))));
        for (class_1767 color : class_1767.values()) {
            String name = baseName + "_" + color.method_7792();
            RegSupplier<class_2248> bb = RegUtils.regBlock(name, () -> (class_2248)presentFactory.apply(color, class_4970.class_2251.method_9639((class_3614)class_3614.field_15931, (class_3620)color.method_7794()).method_9632(1.0f).method_9626((class_2498)ModSounds.PRESENT)));
            map.put(color, (Supplier<class_2248>)bb);
            RegUtils.regItem(name, () -> new PresentItem((class_2248)bb.get(), new class_1792.class_1793().method_7892(RegUtils.getTab(class_1761.field_7928, baseName))));
        }
        return map;
    }

    private static void registerHangingSignBlocks(Registrator<class_2248> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            String name = wood.getVariantId("hanging_sign");
            HangingSignBlock block = new HangingSignBlock(class_4970.class_2251.method_9639((class_3614)wood.material, (class_3620)wood.material.method_15803()).method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547).method_22488().method_9634(), wood);
            wood.addChild("supplementaries:hanging_sign", (Object)block);
            event.register(Supplementaries.res(name), (Object)block);
            ModRegistry.HANGING_SIGNS.put(wood, block);
        }
    }

    public static void registerHangingSignItems(Registrator<class_1792> event, Collection<WoodType> woodTypes) {
        for (Map.Entry<WoodType, HangingSignBlock> entry : ModRegistry.HANGING_SIGNS.entrySet()) {
            WoodType wood = entry.getKey();
            class_2248 block = (class_2248)entry.getValue();
            WoodBasedBlockItem item = new WoodBasedBlockItem(block, new class_1792.class_1793().method_7889(16).method_7892(RegUtils.getTab(class_1761.field_7928, "hanging_sign")), wood, 200);
            event.register(Utils.getID((class_2248)block), (Object)item);
        }
    }

    public static void registerSignPostItems(Registrator<class_1792> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            String name = wood.getVariantId("sign_post");
            SignPostItem item = new SignPostItem(new class_1792.class_1793().method_7889(16).method_7892(RegUtils.getTab(class_1761.field_7928, "sign_post")), wood);
            wood.addChild("supplementaries:sign_post", (Object)item);
            event.register(Supplementaries.res(name), (Object)item);
            ModRegistry.SIGN_POST_ITEMS.put(wood, item);
        }
    }
}

